/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.AbstractTransaction;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Template;

public class InsertEdgeCommand
extends AbstractTransaction {
    Edge edge;
    Template template;
    Nail nail;
    Location target;

    public InsertEdgeCommand(Location source, int x, int y) {
        super(source.getDocument());
        this.template = source.getTemplate();
        this.edge = this.template.createEdge();
        this.edge.setSource(source);
        this.addNail(x, y);
        this.template.insert(this.edge, null);
    }

    public void addNail(int x, int y) {
        this.nail = this.edge.createNail();
        this.nail.setProperty("x", x);
        this.nail.setProperty("y", y);
        this.edge.insert(this.nail, this.edge.getLast());
    }

    public void move(int x, int y) {
        if (this.nail == null) {
            this.addNail(x, y);
        } else {
            this.nail.setProperty("x", x);
            this.nail.setProperty("y", y);
        }
    }

    public void commit(int x, int y) {
        assert (this.edge.getTarget() == null);
        this.target = this.template.createLocation();
        this.target.setProperty("x", x);
        this.target.setProperty("y", y);
        this.template.insert(this.target, null);
        this.edge.setTarget(this.target);
        if (this.nail != null) {
            this.nail.remove();
            this.nail = null;
        }
        super.commit();
    }

    public void commit(Location target) {
        assert (this.edge.getTarget() == null);
        this.edge.setTarget(target);
        if (this.nail != null) {
            this.nail.remove();
            this.nail = null;
        }
        super.commit();
    }

    public boolean hasNails() {
        return this.edge.getFirst() != null && this.edge.getFirst().getNext() != null;
    }

    public Location getSource() {
        return this.edge.getSource();
    }

    public Location getTarget() {
        return this.edge.getTarget();
    }

    @Override
    public void commit() {
        assert (false) : "Must specify target";
    }

    @Override
    protected void doCancel() {
        this.edge.remove();
        this.template = null;
        this.edge = null;
        this.nail = null;
        if (this.target != null) {
            this.target.remove();
            this.target = null;
        }
    }

    @Override
    protected void doExecute() {
        if (this.target != null) {
            this.template.insert(this.target, null);
        }
        this.template.insert(this.edge, null);
    }

    @Override
    protected void doUndo() {
        this.edge.remove();
        if (this.target != null) {
            this.target.remove();
        }
    }
}

