/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.system;

import com.uppaal.model.system.Polyhedron;
import com.uppaal.model.system.SystemLocation;
import java.util.Arrays;

public class SystemState {
    private SystemLocation[] locations;
    private int[] variables;
    private Polyhedron zone;

    public SystemState(SystemLocation[] l, int[] v, Polyhedron z) {
        this.locations = l;
        this.variables = v;
        this.zone = z;
    }

    public String toServerFormat() {
        StringBuffer s = new StringBuffer();
        for (SystemLocation location : this.locations) {
            s.append(String.valueOf(location.getIndex()));
            s.append('\n');
        }
        s.append(".\n");
        s.append(this.zone.writeTextualFormat());
        for (int i : this.variables) {
            s.append(i).append('\n');
        }
        s.append('.');
        return s.toString();
    }

    public String toXTRFormat() {
        return this.toServerFormat() + "\n";
    }

    public String traceFormat() {
        StringBuffer s = new StringBuffer("(");
        boolean first = true;
        for (SystemLocation location : this.locations) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            String name = location.getName();
            s.append(name == null || name.length() == 0 ? "-" : name);
        }
        s.append(")");
        return s.toString();
    }

    public SystemLocation[] getLocationVector() {
        return this.locations;
    }

    public Polyhedron getPolyhedron() {
        return this.zone;
    }

    public int[] getVariables() {
        return this.variables;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        SystemState s = (SystemState)obj;
        return Arrays.equals(this.locations, s.locations) && Arrays.equals(this.variables, s.variables) && this.zone.equals(s.zone);
    }
}

