/*
 * Decompiled with CFR 0.152.
 */
package com.uppaal.model.core2;

import com.uppaal.model.core2.Document;
import com.uppaal.model.core2.Edge;
import com.uppaal.model.core2.Element;
import com.uppaal.model.core2.Location;
import com.uppaal.model.core2.Nail;
import com.uppaal.model.core2.Node;
import com.uppaal.model.core2.Property;
import com.uppaal.model.core2.Template;
import com.uppaal.model.core2.Visitor;

public class AbstractVisitor
implements Visitor {
    @Override
    public void visitElement(Element element) throws Exception {
        if (element.properties != null) {
            for (Property property : element.properties.values()) {
                property.accept(this);
            }
        }
    }

    @Override
    public void visitNode(Node node) throws Exception {
        this.visitElement(node);
        node = node.first;
        while (node != null) {
            node.accept(this);
            node = node.next;
        }
    }

    @Override
    public void visitProperty(Property property) throws Exception {
        this.visitElement(property);
    }

    @Override
    public void visitDocument(Document document) throws Exception {
        this.visitNode(document);
    }

    @Override
    public void visitTemplate(Template template) throws Exception {
        this.visitNode(template);
    }

    @Override
    public void visitLocation(Location location) throws Exception {
        this.visitNode(location);
    }

    @Override
    public void visitEdge(Edge edge) throws Exception {
        this.visitNode(edge);
    }

    @Override
    public void visitNail(Nail nail) throws Exception {
        this.visitNode(nail);
    }
}

